#include <windows.h>											// Header File For Windows
#include <stdlib.h>
#include <stdio.h>
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library

#include "WinFunctions.h"
#include "Utils.h"

LPBYTE mybmp; 

PBITMAPINFO CreateBitmapInfoStruct(HBITMAP hBmp)
{ 
    BITMAP bmp; 
    PBITMAPINFO pbmi; 
    WORD    cClrBits; 

    // Retrieve the bitmap color format, width, and height. 
    if (!GetObject(hBmp, sizeof(BITMAP), (LPSTR)&bmp)) 
		MessageBox(NULL,"CreateBitmapInfoStruct :: GetObject Error", "ERROR", MB_OK);

    // Convert the color format to a count of bits. 
    cClrBits = (WORD)(bmp.bmPlanes * bmp.bmBitsPixel); 
    if (cClrBits == 1) 
        cClrBits = 1; 
    else if (cClrBits <= 4) 
        cClrBits = 4; 
    else if (cClrBits <= 8) 
        cClrBits = 8; 
    else if (cClrBits <= 16) 
        cClrBits = 16; 
    else if (cClrBits <= 24) 
        cClrBits = 24; 
    else cClrBits = 32; 

    // Allocate memory for the BITMAPINFO structure. (This structure 
    // contains a BITMAPINFOHEADER structure and an array of RGBQUAD 
    // data structures.) 

     if (cClrBits != 24) 
         pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
                    sizeof(BITMAPINFOHEADER) + 
                    sizeof(RGBQUAD) * (1<< cClrBits)); 

     // There is no RGBQUAD array for the 24-bit-per-pixel format. 

     else 
         pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
                    sizeof(BITMAPINFOHEADER)); 

    // Initialize the fields in the BITMAPINFO structure. 

    pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER); 
    pbmi->bmiHeader.biWidth = bmp.bmWidth; 
    pbmi->bmiHeader.biHeight = bmp.bmHeight; 
    pbmi->bmiHeader.biPlanes = bmp.bmPlanes; 
    pbmi->bmiHeader.biBitCount = bmp.bmBitsPixel; 
    if (cClrBits < 24) 
        pbmi->bmiHeader.biClrUsed = (1<<cClrBits); 

    // If the bitmap is not compressed, set the BI_RGB flag. 
    pbmi->bmiHeader.biCompression = BI_RGB; 

    // Compute the number of bytes in the array of color 
    // indices and store the result in biSizeImage. 
    // For Windows NT, the width must be DWORD aligned unless 
    // the bitmap is RLE compressed. This example shows this. 
    // For Windows 95/98/Me, the width must be WORD aligned unless the 
    // bitmap is RLE compressed.
    pbmi->bmiHeader.biSizeImage = ((pbmi->bmiHeader.biWidth * cClrBits +31) & ~31) /8
                                  * pbmi->bmiHeader.biHeight; 
    // Set biClrImportant to 0, indicating that all of the 
    // device colors are important. 
     pbmi->bmiHeader.biClrImportant = 0; 
     return pbmi; 
 } 


void CreateBMPFile(LPTSTR pszFile, PBITMAPINFO pbi, 
                  HBITMAP hBMP, HDC hDC) 
 { 
     HANDLE hf;                 // file handle 
    BITMAPFILEHEADER hdr;       // bitmap file-header 
    PBITMAPINFOHEADER pbih;     // bitmap info-header 
    LPBYTE lpBits;              // memory pointer 
    DWORD dwTotal;              // total count of bytes 
    DWORD cb;                   // incremental count of bytes 
    BYTE *hp;                   // byte pointer 
    DWORD dwTmp; 

    pbih = (PBITMAPINFOHEADER) pbi; 
    lpBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
	mybmp = (LPBYTE)malloc(pbih->biHeight * pbih->biWidth * 4 * sizeof(BYTE));// GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);

    if (!lpBits) 
		MessageBox(NULL,"CreateBMPFile :: GlobalAlloc Error", "ERROR", MB_ICONERROR | MB_OK); 

    // Retrieve the color table (RGBQUAD array) and the bits 
    // (array of palette indices) from the DIB. 
    if (!GetDIBits(hDC, hBMP, 0, (WORD) pbih->biHeight, lpBits, pbi, 
        DIB_RGB_COLORS)) 
    {
        MessageBox(NULL,"CreateBMPFile :: GetDIBits Error", "ERROR", MB_ICONERROR | MB_OK); 
    }

	if (!GetDIBits(hDC, hBMP, 0, (WORD) pbih->biHeight, mybmp, pbi, 
        DIB_RGB_COLORS)) 
    {
        MessageBox(NULL,"CreateBMPFile :: GetDIBits Error", "ERROR", MB_ICONERROR | MB_OK); 
    }

    // Create the .BMP file. 
    hf = CreateFile(pszFile, 
                   GENERIC_READ | GENERIC_WRITE, 
                   (DWORD) 0, 
                    NULL, 
                   CREATE_ALWAYS, 
                   FILE_ATTRIBUTE_NORMAL, 
                   (HANDLE) NULL); 
    if (hf == INVALID_HANDLE_VALUE) 
        MessageBox(NULL,"CreateBMPFile :: CreateFile Error", "ERROR", MB_ICONERROR | MB_OK);  
    hdr.bfType = 0x4d42;        // 0x42 = "B" 0x4d = "M" 
    // Compute the size of the entire file. 
    hdr.bfSize = (DWORD) (sizeof(BITMAPFILEHEADER) + 
                 pbih->biSize + pbih->biClrUsed 
                 * sizeof(RGBQUAD) + pbih->biSizeImage); 
    hdr.bfReserved1 = 0; 
    hdr.bfReserved2 = 0; 

    // Compute the offset to the array of color indices. 
    hdr.bfOffBits = (DWORD) sizeof(BITMAPFILEHEADER) + 
                    pbih->biSize + pbih->biClrUsed 
                    * sizeof (RGBQUAD); 

    // Copy the BITMAPFILEHEADER into the .BMP file. 
    if (!WriteFile(hf, (LPVOID) &hdr, sizeof(BITMAPFILEHEADER), 
        (LPDWORD) &dwTmp,  NULL)) 
    {
       MessageBox(NULL,"CreateBMPFile :: WriteFile Error - Writing header", "ERROR", MB_ICONERROR | MB_OK); 
    }

    // Copy the BITMAPINFOHEADER and RGBQUAD array into the file. 
    if (!WriteFile(hf, (LPVOID) pbih, sizeof(BITMAPINFOHEADER) 
                  + pbih->biClrUsed * sizeof (RGBQUAD), 
                  (LPDWORD) &dwTmp, ( NULL)))
        MessageBox(NULL,"CreateBMPFile :: WriteFile Error - Writing info header", "ERROR", MB_ICONERROR | MB_OK);  

    // Copy the array of color indices into the .BMP file. 
    dwTotal = cb = pbih->biSizeImage; 
    hp = lpBits; 
    if (!WriteFile(hf, (LPSTR) hp, (int) cb, (LPDWORD) &dwTmp,NULL)) 
           MessageBox(NULL,"CreateBMPFile :: WriteFile Error - Writing body", "ERROR", MB_ICONERROR | MB_OK);  

    // Close the .BMP file. 
     if (!CloseHandle(hf)) 
           MessageBox(NULL,"CreateBMPFile :: CloseFile Error", "ERROR", MB_ICONERROR | MB_OK); 

    // Free memory. 
    GlobalFree((HGLOBAL)lpBits);
}


void CreateBackgroundTexture(GLuint *targetTex, int px, int py, int w, int h){
			
	HDC hdcScreen = GetDC(GetDesktopWindow());//CreateDC("DISPLAY", NULL, NULL, NULL);
	   
	HDC hdcCompatible = CreateCompatibleDC(hdcScreen);

	//HBITMAP hbmWnd = CreateCompatibleBitmap(hdcScreen, GetDeviceCaps(hdcScreen, HORZRES),GetDeviceCaps(hdcScreen, VERTRES));
	HBITMAP hbmWnd = CreateCompatibleBitmap(hdcScreen, w, h);
		
	SelectObject(hdcCompatible, hbmWnd);

	//BitBlt(hdcCompatible,0,0,GetDeviceCaps(hdcScreen, HORZRES),GetDeviceCaps(hdcScreen, VERTRES), hdcScreen, 0, 0, SRCCOPY | CAPTUREBLT);
	BitBlt(hdcCompatible,0,0,w,h, hdcScreen, px, py, SRCCOPY | CAPTUREBLT);


	//LockResource(hbmWnd);
GdiFlush();
	//get info about the bitmap
	
	BITMAP BM;
	
	if(GetObject(hbmWnd, sizeof(BITMAP), &BM) <= 0){
		MessageBox(NULL, "Nopes", "info", MB_OK);
	}

	glEnable(GL_TEXTURE_2D);
	glGenTextures(1, targetTex);
		
	//glBindTexture(GL_TEXTURE_2D, *targetTex);

	//tell OpenGL to ignore padding at ends of rows
	glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
	//glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
    //glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
    //glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0); 
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);


	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);

	const int tsW = AlignToPow2(BM.bmWidth);
	const int tsH = AlignToPow2(BM.bmHeight);

	const int tsD = tsW * tsH * 4;
	unsigned char *texData = new unsigned char[tsD];
	memset(texData, 200, sizeof(unsigned char)*tsD);
	//memset(texData+sizeof(unsigned char)*512*512*3, 128, sizeof(unsigned char)*512*512*3);
	
	
	PBITMAPINFO pbi = CreateBitmapInfoStruct(hbmWnd);      
	CreateBMPFile("back.bmp",pbi,hbmWnd,hdcCompatible);

	

	//HBITMAP bmp = (HBITMAP)LoadImage(NULL,"back.bmp",IMAGE_BITMAP,w, h,LR_CREATEDIBSECTION | LR_LOADFROMFILE);

	BITMAPINFO info;
	BITMAPINFOHEADER header;
	header.biSize = sizeof(BITMAPINFOHEADER);
	header.biWidth = tsW;
	header.biHeight = tsH;
	header.biPlanes = 1;
	header.biBitCount = BM.bmBitsPixel;
	header.biCompression = BI_RGB;
	header.biSizeImage = 0;
	header.biClrUsed = 0;
	header.biClrImportant = 0;

	info.bmiHeader = header;
	info.bmiColors->rgbRed = NULL;
	info.bmiColors->rgbGreen = NULL;
	info.bmiColors->rgbBlue = NULL;
	info.bmiColors->rgbReserved = NULL;
	
	GetDIBits(
  hdcCompatible,           // handle to DC
  hbmWnd,      // handle to bitmap
  0,   // first scan line to set
  h,   // number of scan lines to copy
  &texData,    // array for bitmap bits
  &info, // bitmap data buffer
  DIB_RGB_COLORS        // RGB or palette index
);

	char str[512] = "";
	sprintf(str, "%x,%x,%x,%x", texData[0], texData[1], texData[2], texData[3]);
	//sprintf(str, "%d, %d, %d, %d (%d)", BM.bmWidth, BM.bmHeight, tsW, tsH, BM.bmBitsPixel);
    MessageBox(NULL, str, "info", MB_OK);


	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tsW, tsH, 0, GL_BGRA_EXT, GL_UNSIGNED_BYTE, texData);
	//glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, BM.bmWidth, BM.bmHeight,0, GL_BGR_EXT, GL_UNSIGNED_BYTE, BM.bmBits);
	// ou 
	//gluBuild2DMipmaps( GL_TEXTURE_2D, 3, tsW, tsH,GL_BGRA_EXT, GL_UNSIGNED_BYTE, texData );

	delete [] texData;
	


	//char str[512] = "";
	//sprintf(str, "%d - %d,%d", BM.bmWidthBytes, BM.bmWidth, BM.bmHeight);
 //   MessageBox(NULL, str, "info", MB_OK);

	glDisable(GL_TEXTURE_2D);

	DeleteObject(&BM);

	DeleteObject(hbmWnd);
	DeleteDC(hdcCompatible);
	
	ReleaseDC(GetDesktopWindow(),hdcScreen);
	
	   
	return;
}

